-------------------------------------
-- implementation of the clean screen
-------------------------------------

local TXT_COLOR_START = 0xD8E1E5 -- text color to use during the first half
local TXT_COLOR_END = 0x4C5153   -- text color to use during the second half
local BG_COLOR_START = 0xffffff  -- background color to use during the first half
local BG_COLOR_END = 0x000000    -- background color to use during the second half

local gCleanTimeout = 60         -- total time the screen is locked for cleaning in seconds
local gCleanTimerId = nil        -- countdown timer
local gCleanProgress = 0         -- time the screen is already locked

--
-- update the countdown timer on the screen, when it expires unlock the screen
--
local function update_countdown()
  gCleanProgress = gCleanProgress + 1
  
  local data = {}
  data["Clean_Layer.Countdown_Text.text"] = string.format("%d", gCleanTimeout - gCleanProgress)
  if (gCleanProgress * 2) >= gCleanTimeout then
    data["Clean_Layer.Countdown_Text.text_color"] = TXT_COLOR_END
    data["Clean_Layer.Countdown_Text.background_color"] = BG_COLOR_END
    data["Clean_Layer.IconTop_Img.grd_hidden"] = true
    data["Clean_Layer.IconBottom_Img.grd_hidden"] = false
  end
  gre.set_data(data)
  
  if gCleanTimeout == gCleanProgress then
    gre.send_event("clean_screen_timer")
  end
end

--
-- leave screen (cleanly or halfway through)
--
function CBClean_OnScreenHide()
  if gCleanTimerId ~= nil then
    gre.timer_clear_interval(gCleanTimerId)
    gCleanTimerId = nil
  end
  Event:enable_touch()
end

--
-- lock the screen for a certain amount of time to allow cleaning
--
function CBClean_Prepare()
  if gCleanTimerId ~= nil then
    gre.timer_clear_interval(gCleanTimerId)
    gCleanTimerId = nil
  end
  
  gCleanTimeout = Settings:get_def("CLEANSCREEN_TIME", 60)
 
  local data = {}  
  data["Clean_Layer.Countdown_Text.text"] = string.format("%d", gCleanTimeout)
  data["Clean_Layer.Countdown_Text.text_color"] = TXT_COLOR_START
  data["Clean_Layer.Countdown_Text.background_color"] = BG_COLOR_START
  data["Clean_Layer.IconTop_Img.grd_hidden"] = false
  data["Clean_Layer.IconBottom_Img.grd_hidden"] = true
  gre.set_data(data)
  
  Event:disable_touch()
  
  gCleanProgress = 0
  gCleanTimerId = gre.timer_set_interval(update_countdown, 1000)
end
