--------------------------------
-- recipe icon selection overlay
--------------------------------

require("Scrollbar")

local SELECTICON_LAYER = "SelectIcon_Layer"
local SELECTICON_TABLE = SELECTICON_LAYER .. ".icon_table"
local SELECTICON_SCROLLBAR = SELECTICON_LAYER .. ".Scrollbar"

local gScrollbar = Scrollbar.new{ table=SELECTICON_TABLE, scrollbar=SELECTICON_SCROLLBAR }
local gIcons = {}

--
-- when icon list dir reply is received, put the available icons in a local table
--
function CBCR_InitIcons(files)
  for _, file in pairs(files) do
    if string.sub(file, -10) ~= "_large.png" then
      table.insert(gIcons, file)
    end
  end
end

--
-- update scrollbar slider location
--
function CBCR_IconSelect_SyncScrollbar()
  gScrollbar:scroll()
end

--
-- select an icon
--
function CBCR_IconSelect_OnSelectTableRow(mapargs)
  local row = mapargs.context_row
  local x = mapargs.context_event_data.x
  
  local icon_index = (row - 1) * 3
  if x < 165 then
    icon_index = icon_index + 1
  elseif x > 315 then
    icon_index = icon_index + 3
  else
    icon_index = icon_index + 2
  end

  gre.set_layer_attrs(SELECTICON_LAYER, { hidden=true })
  gre.send_event_data("select_icon", "1s0 icon", { icon=gIcons[icon_index] })
end

--
-- display icon selection overlay
--
function CBCR_IconSelect_OnOverlayShow()
  local data = {}

  local row_count = 0
  for index=1,#gIcons,3 do
    row_count = row_count + 1
    if index <= #gIcons then
      data[SELECTICON_TABLE..".icon_1."..row_count..".1"] = icon_path(gIcons[index])
    end
    if index + 1 <= #gIcons then
      data[SELECTICON_TABLE..".icon_2."..row_count..".1"] = icon_path(gIcons[index + 1])
    end
    if index + 2 <= #gIcons then
      data[SELECTICON_TABLE..".icon_3."..row_count..".1"] = icon_path(gIcons[index + 2])
    end
    data[SELECTICON_TABLE..".top_line_alpha."..row_count..".1"] = row_count == 1 and 255 or 0
  end

  gre.set_data(data)
  gre.set_table_attrs(SELECTICON_TABLE, { rows=row_count, yoffset=0 })

  gScrollbar:init()
  
  gre.set_layer_attrs(SELECTICON_LAYER, { hidden=false })
end
