----------------------------------------
-- recipe step temperature input overlay
----------------------------------------

require("language")
require("Temperature")

local TEMPERATURE_FIELD = "EditTemperature_Overlay.temperature_text.text"

local gTemperatureText = ""

local gCurrentTemperature = Temperature.new{temp = 0}
local gMinTemperature = Temperature.new{temp = 0}
local gMaxTemperature = Temperature.new{temp = 0}

--
-- get the new temperature and close the dialog
--
function StepTemperature_GetAndClose()
  gre.set_layer_attrs("CR_Screen.EditTemperature_Overlay", { hidden = true })
  
  if #gTemperatureText == 0 then
    gCurrentTemperature:set(0)
  else
    gCurrentTemperature:set(tonumber(gTemperatureText))
  end
  
  if gCurrentTemperature:get() < gMinTemperature:get() then gCurrentTemperature:set(gMinTemperature:get()) end
  if gCurrentTemperature:get() > gMaxTemperature:get() then gCurrentTemperature:set(gMaxTemperature:get()) end
  
  return gCurrentTemperature
end

--
-- key pressed
--
function CBCR_StepTemperature_InputKeyEvent(mapargs)
  local code = mapargs.context_event_data.code
  
  if code == 8 then
    -- backspace, remove last char
    gTemperatureText = string.sub(gTemperatureText, 1, #gTemperatureText-1)
  else
    -- append char
    for _, char in ipairs({'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}) do
      if string.char(code) == char then
        gTemperatureText = gTemperatureText..char
      end
    end
  end
  
  gre.set_value(TEMPERATURE_FIELD, string.format(gTemperatureText.."|"))
end

--
-- show edit step temperature dialog
--
function CBCR_StepTemperature_OnOverlayShow(actual, min, max)
  if actual < min then actual = min end
  if actual > max then actual = max end

  gCurrentTemperature:setC(actual)
  gMinTemperature:setC(min)
  gMaxTemperature:setC(max)

  local data = {}
  
  data["EditTemperature_Overlay.min_text.text"] = string.format("%s %s", i18n:get("NLS_MIN"), gMinTemperature:to_string(true))
  data["EditTemperature_Overlay.max_text.text"] = string.format("%s %s", i18n:get("NLS_MAX"), gMaxTemperature:to_string(true))
  
  gTemperatureText = string.format("%d", gCurrentTemperature:get_rounded())
  data[TEMPERATURE_FIELD] = string.format(gTemperatureText.."|")
  
  gre.set_data(data)
  
  gre.set_layer_attrs("CR_Screen.EditTemperature_Overlay", { hidden = false })
  gre.set_layer_attrs("Keyboard_Layer_v2", { hidden = false })
end
