
----------------------------------------------------------------
-- storage of the cleaning total times of all cleaning programs
----------------------------------------------------------------

-- singleton class
CleaningTotalTimes = {}
CleaningTotalTimes.__index = CleaningTotalTimes
CleaningTotalTimes.db = {}        -- database of totaltimes for clean mode names
CleaningTotalTimes.showProgramSelection = false -- don't show clean program selection on receiving the total times for all cleaning programs.

--
-- set a totaltime in the database
--
function CleaningTotalTimes:set(key, value)
    self.db[key] = value
  end

  --
  -- read a total time from the database
  -- return a string hh:mm:ss
  --
  function CleaningTotalTimes:get(key)
    local totaltime = self.db[key]
    if totaltime then
      local _, _, _, h, min, ss = utc_time(totaltime)
      return string.format("%02d:%02d:%02d", h, min, ss)
    else
      return ""
    end
  end

