----------
-- globals
----------

EVENT_CHANNEL             = "output"                    -- channel on which to send events to the backend
DELIMITER_TOKEN           = string.char(0x1D)           -- delimiter used to implode multiple strings (group separator)
DEGREE_SYMBOL             = string.char(0xC2,0xB0)      -- degree symbol "°" encoded in utf-8
INFINITY_SYMBOL           = string.char(0xE2,0x88,0x9E) -- infinity symbol "∞" encoded in utf-8
NBSP                      = string.char(0xC2,0xA0)      -- non-breaking space encoded in utf-8
DISPLAY_UPDATE_DELAY_MS   = 500                         -- time it takes for display to refresh after a change

--
-- determine what the os path separator is
--
local function get_path_sep()
  return string.find(gre.SCRIPT_ROOT, "/") and "/" or "\\"
end

--
-- get the storyboard application root directory
--
local function get_root_dir()
  return string.sub(gre.SCRIPT_ROOT, string.find(gre.SCRIPT_ROOT, ".*[/\\]"))
end

local PATH_SEP            = get_path_sep()         -- os path separator
local ROOT_DIR            = get_root_dir()         -- storyboard application root directory
local IMAGES_DIR          = "images"               -- directory containing image files
local FONTS_DIR           = "fonts"                -- directory containing font filess
local CONFIG_DIR          = "config"               -- directory containing configuration files
local TRANSLATIONS_DIR    = "translations"         -- directory containing translation files
local ICONS_DIR           = "icons"                -- directory containing recipe icons
local SCREENSHOTS_DIR     = "screenshots"          -- directory containing screenshots
local TMP_SCREENSHOT_FMT  = "tmp_%s.bmp"           -- name for newly taken screenshot, before it's saved
local CUSTOMER_IMAGE      = "customer.png"         -- name of the customer specific image shown during startup
local CUSTOMER_IMAGE_DIR  = CONFIG_DIR             -- directory container the customer specific image
local USB_DRIVE           = "A:"
local SETTINGS_DIR        = "PARAMS"
local RECIPES_DIR         = "PROGRAMS"
local HELP_DIR            = "help"
local LICENSE_DIR         = "license"
local LICENSE_FILE        = "S-Control_license.txt"

function settings_dir_usb() return USB_DRIVE..PATH_SEP..SETTINGS_DIR end
function recipes_dir_usb() return USB_DRIVE..PATH_SEP..RECIPES_DIR end
function absolute_path(relative_path) return ROOT_DIR..relative_path end
function image_path(image_file) return IMAGES_DIR..PATH_SEP..image_file end
function font_path(font_file) return FONTS_DIR..PATH_SEP..font_file end
function config_dir() return ROOT_DIR..CONFIG_DIR end
function config_path(config_file) return ROOT_DIR..CONFIG_DIR..PATH_SEP..config_file end
function translations_dir() return ROOT_DIR..TRANSLATIONS_DIR end
function translation_path(translation_file) return ROOT_DIR..TRANSLATIONS_DIR..PATH_SEP..translation_file end
function icons_dir() return ROOT_DIR..ICONS_DIR end
function icon_path(icon_file) return ICONS_DIR..PATH_SEP..icon_file end
function screenshots_dir() return ROOT_DIR..SCREENSHOTS_DIR end
function screenshot_path(screenshot_file) return SCREENSHOTS_DIR..PATH_SEP..screenshot_file end
function tmp_screenshot_name(timestamp) return string.format(TMP_SCREENSHOT_FMT, timestamp) end
function customer_image() return CUSTOMER_IMAGE_DIR..PATH_SEP..CUSTOMER_IMAGE end
function help_dir(subdir, help_file) return ROOT_DIR..HELP_DIR..PATH_SEP..subdir..PATH_SEP..help_file end
function license_file() return ROOT_DIR..LICENSE_DIR..PATH_SEP..LICENSE_FILE end
