-------------------------------------------------------
-- callbacks and operations related to the about screen
-------------------------------------------------------

require("QrCode")

local FRI_INFO_TEXT = "FRI_Layer.FRI_Text.FRI_Info_Text_" -- prefix of all the text controls on this screen
local QRCODE_CVS = "QrCode_Cvs"

local gQrCode = QrCodeWidget.new{canvas="serialnumber_qrcode"}

--
--  make a version string from given iVersion integer
--- in format M.m.bb
--
local function Version_String(iVersion)
  local MM = math.floor(iVersion/10000)
  local left = iVersion - MM*10000
  local mm = math.floor(left/100)
  local bb = left - mm*100
  return(string.format("%d.%d.%02d", MM, mm, bb))
end

--
-- convert device type id to device name
--
local function DeviceType_String()
  return i18n:get("DEVICE_TYPE" .. "." .. Settings:get_def("DEVICE_TYPE", 0))
end

--
-- Set the text in the info text control
--
local function set_text(i, iText)
  local text = iText;
  gre.set_value(FRI_INFO_TEXT..i..".text", text)
end

--
-- Move text field i taking into account width of text in field j
--
local function move_text_field(i, j)
  local fieldJX = gre.get_control_attrs(FRI_INFO_TEXT..j, "x").x
  local fieldJFont = gre.get_value(FRI_INFO_TEXT..j..".font")
  local fieldJFontSize = gre.get_value(FRI_INFO_TEXT..j..".size")
  local fieldJText = gre.get_value(FRI_INFO_TEXT..j..".text")

  local widthOfJText = gre.get_string_size(fieldJFont, fieldJFontSize, fieldJText).width
  local widthOfSpace = gre.get_string_size(fieldJFont, fieldJFontSize, " ").width
  local newX = fieldJX + widthOfJText + widthOfSpace

  gre.set_value(FRI_INFO_TEXT..i..".grd_x", newX)
end

--
-- Action before the FRI Screen is showed
--
--- @param gre#context mapargs
function CBFRI_Prepare(mapargs)
  -- menu buttons
  Control_SetButtons(true, true, true, true, true, true, false)

  -- populate our control
  set_text(1, DeviceType_String())
  set_text(2, i18n:get("NLS_ABOUT_VERSION"))
  set_text(3, string.format("%d.%d.%02d", Settings:get("VERSIONMAJOR"), Settings:get("VERSIONMINOR"), Settings:get("VERSIONBETA")) )
  set_text(4, i18n:get("NLS_ABOUT_IOBOARD"))
  set_text(5, "v" .. Version_String(Settings:get("TEMB_VERSION")))

  -- 9-digit S/N
  local serial_number = string.format("%s", Settings:get("SERIALNR_STR"))
  local enroll_url_string = string.format("%s", Settings:get("ENROLL_URL_STR"))
  local wifi_available = (Settings:get("WIFI_AVAILABLE") == 1)
  if wifi_available then
    set_text(6, i18n:get("NLS_ABOUT_SERIAL"))
    set_text(7, serial_number)
  else
    set_text(6, " ") -- don't show serial number, PD42S software without wifi doesn't know its own serialnumber.
    set_text(7, " ")
  end

  local product_name = string.format("%s", Settings:get("PRODUCT_NAME_STR"))
  set_text(8, i18n:get("NLS_PRODUCT_NAME"))
  set_text(9, product_name)

  local part_number = string.format("%s", Settings:get("PART_NR_STR"))
  if string.len(part_number) > 6 then
    set_text(10, i18n:get("NLS_PART_NUMBER"))
    set_text(11, part_number)
  else
    set_text(10, " ") -- don't show a part number if part number isn't known. (ovens before Feb 2025)
    set_text(11, " ")
  end

  -- move text 3, 5 and 7 to take into account width of text 2, 4 and 6 respectively
  move_text_field(3, 2)
  move_text_field(5, 4)
  move_text_field(7, 6)

  move_text_field(9, 8)
  move_text_field(11, 10)

  -- make a QR code for the enroll URL + serial number
  if wifi_available then
    gQrCode:show(enroll_url_string .. serial_number)
    gre.set_value("FRI_Layer.QrCode_Cvs.grd_hidden", false)
  else
    gre.set_value("FRI_Layer.QrCode_Cvs.grd_hidden", true) -- don't show QR code of the serialnumber, since serialnumber is unknown.
  end
end
