----------------------------------
-- Help screen / Table of contents
----------------------------------

--[[ includes ]]--
require("Helpdir")
require("Dialog")
require("Scrollbar")
require("Util")

local json = require("json")

--[[ local data ]]--

local gHelpTopics = nil
local gScrollbar = Scrollbar.new{table="HelpToc_Layer.HelpTopics_Table",scrollbar="HelpBackground_Layer.Scrollbar"}

--[[ local functions ]]--

--
-- parse help topics json file and build index
--
local function parse_toc_json(toc_file)
  local f = assert(io.open(toc_file, "r"))
  local t = f:read("*all")
  f:close()

  local json_data = json.decode(t)

  gHelpTopics = {}
  for key, value in pairs(json_data) do
    table.insert(gHelpTopics, {key=key,title=value.title,file=help_path(value.file)})
  end
  table.sort(gHelpTopics, function(a, b) return a.key < b.key end)
end

--
-- fill table of contents with help topics
--
local function populate_toc()
  local data = {}
  for index, topic in ipairs(gHelpTopics) do
    data["HelpToc_Layer.HelpTopics_Table.text."..index..".1"] = topic.title
  end
  gre.set_data(data)
  gre.set_table_attrs("HelpToc_Layer.HelpTopics_Table", {yoffset=0,rows=#gHelpTopics})

  gScrollbar:init()
end

--[[ event handlers ]]--

--
-- synchronize scrollbar location to table position
--
function CBHelp_Toc_SyncScrollbar(mapargs)
  gScrollbar:scroll()
end

--
-- help topic selected from list
--
function CBHelp_Toc_OnSelectItem(mapargs)
  local topic_file = gHelpTopics[mapargs.context_row].file
  if file_exists(topic_file) then
    Help_ShowTopic(topic_file, function() gScrollbar:init() end)
  else
    local dlg = DialogBox.new(DIALOG_TYPE_INFORMATION)
    dlg:set_message(i18n:get("NLS_FS_ERR_NOTFOUND"))
    dlg:add_button(i18n:get("NLS_OK"))
    dlg:show()
  end
end

--
-- prepare screen for displaying (populate toc)
--
function CBHelp_Toc_OnScreenShow(mapargs)
  -- menu buttons
  Control_SetButtons(true, true, true, true, true, true, false)
  
  -- parse and display help json
  parse_toc_json(help_path("toc.json"))
  populate_toc()
end
