----------
-- globals
----------
require("Settings")
require("Config")

-------------------------------------------------------------------------------
-- Returns the correct directory path containing the help files displayed by the GUI
--
-- There is a subdivision for devices with AutoCleaning and without Autocleaning
-- the second subdivision is determined by the customer ID set in "Service->Customer ID" menu.
--
-- For instance:
-- * Devices at Walmart with auto clean will have directory: "AutoClean\1"
-- * Devices at other places without auto clean will have directory: "HandClean\'customer ID`"
-------------------------------------------------------------------------------
function help_path(help_file)
  local cleaning_enabled = Settings:get("CLEANING_SUPPORTED") == 1
  local customer_id_str = tostring(Settings:get("CUSTOMER_ID"))
  local subdir_str = ""

  if cleaning_enabled then
    subdir_str = customer_id_str.."AutoClean"
  else
    subdir_str = customer_id_str.."HandClean"
  end
  return help_dir(subdir_str, help_file)
end

