---------------------------------------
-- 3rd party license information screen
---------------------------------------

require("Config")
require("Dialog")
require("Scrollbar")

local LICENSE_FILE_MISSING_MSG = "<p style=\"font-size:36px;\">License file missing!</p><ul><li>License file could not be found.</li><li>Expected license file location: \"%s\"</li></ul>"
local LICENSE_FILE_EMPTY_MSG = "<p style=\"font-size:36px;\">License file empty!</p><ul><li>A license file was found, but appears to be empty.</li><li>License file location: \"%s\"</li></ul>"
local LICENSE_LAYER = "LICENSE_Screen.License_Text_Layer"
local LICENSE_CONTROL = "License_Text_Layer.License_Text"
local SCROLLBAR = "Licenses_Layer.Scrollbar"

local gScrollbar = LayerScrollbar.new{layer=LICENSE_LAYER,scrollbar=SCROLLBAR}

--
-- license layer scrolling, synchronize scrollbar
--
function CBLICENSE_SyncScrollbar(mapargs)
  gScrollbar:scroll()
end

--
-- display license text on the screen
--
local function show_license_text(file_path, content)
  if content == nil then content = string.format(LICENSE_FILE_MISSING_MSG, file_path) end
  if content == ""  then content = string.format(LICENSE_FILE_EMPTY_MSG, file_path) end

  local height = gre.rtext_text_extent(content, LICENSE_CONTROL).height
  
  local data = {}
  data[LICENSE_CONTROL..".text"] = content
  data[LICENSE_CONTROL..".grd_height"] = height
  gre.set_data(data)
  
  gScrollbar:init(height)
end

--
-- read the license file
--
local function read_license_file(file_path)
  local t = nil
  local f = io.open(file_path, "r")
  if f then
    t = f:read("*all")
    f:close()
  end
  if not t then
    local dlg = DialogBox.new(DIALOG_TYPE_INFORMATION)
    dlg:set_message("License file missing or empty!")
    dlg:add_button(i18n:get("NLS_OK"))
    dlg:show()   
  end
  return t
end

--
-- prepare license screen for display (before showing)
--
function CBLICENSE_OnScreenShow(mapargs)
  local license_file_path = license_file()
  show_license_text(license_file_path, read_license_file(license_file_path))
  Control_SetButtons(true, true, true, true, true, true, false)
end
