--
-- Live variables
--

--
-- called when gCurrentMenu in entered
--  todo: should scan menu items for live vars
--
function LiveVars_CurMenu_Enter()
  local menu_active = (gre.get_value("SET_Screen.activeLayer") == "SET_Menu_Layer")
  if menu_active then
    if gCurrentMenu.key == "IO_TEST_MENU" then
      Event:iotest_start()
    elseif gCurrentMenu.key == "MANAGER_MENU" then
      LiveVars_GetBase()
    elseif  gCurrentMenu.key == "SERVICE_MENU" then
      Event:live_get("IGNORE_ERRORS")
    elseif  gCurrentMenu.key == "LIVEVARS_MENU" then
      Event:action("LIVEVARS_REFRESH")
    elseif  gCurrentMenu.key == "STATUS_COUNTERS_MENU" then
      Event:action("LIVEVARS_REFRESH")
    elseif  gCurrentMenu.key == "OUTPUT_COUNTERS_MENU" then
      Event:action("LIVEVARS_REFRESH")
    elseif  gCurrentMenu.key == "START_END_COUNTERS_MENU" then
      Event:action("LIVEVARS_REFRESH")
    end
  else
    local item = gCurrentMenu.items[gLastRow]
    if item ~= nil and item.isLive then
      Event:iotest_start()
    end
  end
end

--
-- called when gCurrentMenu in leaving
--
function LiveVars_CurMenu_Leave()
  local menu_active = (gre.get_value("SET_Screen.activeLayer") == "SET_Menu_Layer")
  if menu_active then
    if gCurrentMenu.key == "IO_TEST_MENU" then
      Event:iotest_end()
    end
  else
    local item = gCurrentMenu.items[gLastRow]
    if item ~= nil and item.isLive and gCurrentMenu.key ~= "IO_TEST_MENU" then
      Event:iotest_end()
    end
  end
end

--
-- Is the oven idle?
--
function LiveVars_OvenIdle()
  local ovenstate = Settings:get("OVENSTATE")

  return ovenstate == 0
end
--
-- request to send the values of base live variables(no i/o)
--
function LiveVars_GetBase()
  local ids = "LASTERROR;LIMEFILTER"

  Event:live_get(ids)
end

--
-- handle io_live_value event
-- ( reply of Event:live_get() )
--
-- @param gre#context mapargs
function CB_LiveValue(mapargs)
  local id = mapargs.context_event_data.id
  local value = mapargs.context_event_data.value

  -- store them in the Settings
  Settings:set(id, value)
  -- notify SET_Menu_Layer
  gre.send_event_data("livevar_changed", "1s0 id", { id = id })
end
