-------------------------------------------------------
-- callbacks and operations related to the login dialog
-------------------------------------------------------

require("language")
require("RoleManager")
require("Utf8")

local gContextScreen = ""
local gRequestedRole = END_USER_ROLE
local gLoginCallback = nil

--
-- key pressed
--
function CBLogin_InputKeyEvent(mapargs)
  local code = mapargs.context_event_data.code
  local pincode = gre.get_value("Login_Layer.pincode_group.pincode")

  if code == 8 then
    -- backspace, remove last char
    pincode = Utf8_RemoveLastCharacter(pincode)
  else
    -- append char
    local tmp = pincode..Utf8_FromUcs2(code)
    if Utf8_StrLen(tmp) <= 4 then
      pincode = tmp
    end
  end

  local data = {}
  local length = Utf8_StrLen(pincode)
  data["Login_Layer.pincode_group.pincode"] = pincode
  data["Login_Layer.pincode_group.pincode_text_1.text"] = length >= 1 and "*" or ""
  data["Login_Layer.pincode_group.pincode_text_2.text"] = length >= 2 and "*" or ""
  data["Login_Layer.pincode_group.pincode_text_3.text"] = length >= 3 and "*" or ""
  data["Login_Layer.pincode_group.pincode_text_4.text"] = length >= 4 and "*" or ""
  gre.set_data(data)
end

--
-- ok pressed, attempt to login
--
function CBLogin_OnOkPressed()
  local pincode = gre.get_value("Login_Layer.pincode_group.pincode")
  RoleManager:request_elevation(gRequestedRole, pincode)

  local data = {}
  data["Login_Layer.pincode_group.pincode"] = ""
  data["Login_Layer.pincode_group.pincode_text_1.text"] = ""
  data["Login_Layer.pincode_group.pincode_text_2.text"] = ""
  data["Login_Layer.pincode_group.pincode_text_3.text"] = ""
  data["Login_Layer.pincode_group.pincode_text_4.text"] = ""
  gre.set_data(data)
end

--
-- cancel pressed
--
function CBLogin_OnCancelPressed()
  local data = {}
  data["Login_Layer.pincode_group.pincode"] = ""
  data["Login_Layer.pincode_group.pincode_text_1.text"] = ""
  data["Login_Layer.pincode_group.pincode_text_2.text"] = ""
  data["Login_Layer.pincode_group.pincode_text_3.text"] = ""
  data["Login_Layer.pincode_group.pincode_text_4.text"] = ""
  data["Login_Layer.feedback_text.text"] = ""
  gre.set_data(data)
  -- DID16872 Hide the Login_Layer on all screens, not just on the 'gContextScreen' screen.
  gre.set_layer_attrs_global("Login_Layer", { hidden = true })
  gre.send_event("login_canceled")
end

--
-- elevation granted, close dialog and send refresh request to settings screen
--
function CBLogin_OnElevationGranted()
  local data = {}
  data["Login_Layer.feedback_text.text"] = ""
  gre.set_data(data)
  -- DID16872 Hide the Login_Layer on all screens, not just on the 'gContextScreen' screen.
  gre.set_layer_attrs_global("Login_Layer", { hidden = true })

  gre.send_event("login_success")

  if gLoginCallback ~= nil and gRequestedRole == RoleManager:get_role() then
    gLoginCallback()
    gLoginCallback = nil
  end
end

--
-- elevation denied, incorrect pin
--
function CBLogin_OnElevationDenied()
  local data = {}
  data["Login_Layer.pincode_group.pincode"] = ""
  data["Login_Layer.pincode_group.pincode_text_1.text"] = ""
  data["Login_Layer.pincode_group.pincode_text_2.text"] = ""
  data["Login_Layer.pincode_group.pincode_text_3.text"] = ""
  data["Login_Layer.pincode_group.pincode_text_4.text"] = ""
  data["Login_Layer.feedback_text.text"] = i18n:get("NLS_LOGIN_INCORRECTPIN")
  gre.set_data(data)
end

--
-- too many attempts, wait for cooldown to try again
--
function CBLogin_OnElevationCooldown(mapargs)
  local cooldown_time = mapargs.context_event_data.wait

  local feedback_text = ""
  if cooldown_time then
    feedback_text = string.format(i18n:get("NLS_LOGIN_MAXATTEMPTSS"), cooldown_time)
  else
    feedback_text = string.format(i18n:get("NLS_LOGIN_MAXATTEMPTS"))
  end

  local data = {}
  data["Login_Layer.pincode_group.pincode"] = ""
  data["Login_Layer.pincode_group.pincode_text_1.text"] = ""
  data["Login_Layer.pincode_group.pincode_text_2.text"] = ""
  data["Login_Layer.pincode_group.pincode_text_3.text"] = ""
  data["Login_Layer.pincode_group.pincode_text_4.text"] = ""
  data["Login_Layer.feedback_text.text"] = feedback_text
  gre.set_data(data)
end

--
-- open the login dialog to attempt to elevate to the desired role
--
function LoginDialog_Init(context_screen, requested_role, login_callback)
  gContextScreen = context_screen
  gRequestedRole = requested_role
  gLoginCallback = login_callback

  if RoleManager:is_pin_required(gRequestedRole) then
    local data = {}
    data["Login_Layer.pincode_group.pincode"] = ""
    data["Login_Layer.pincode_group.pincode_text_1.text"] = ""
    data["Login_Layer.pincode_group.pincode_text_2.text"] = ""
    data["Login_Layer.pincode_group.pincode_text_3.text"] = ""
    data["Login_Layer.pincode_group.pincode_text_4.text"] = ""
    data["Login_Layer.feedback_text.text"] = ""
    gre.set_data(data)
    gre.set_layer_attrs(gContextScreen..".Login_Layer", { hidden = false })
  else
    RoleManager:request_elevation(gRequestedRole, 0)
  end
end
