------------------
-- Messages screen
------------------

require("events")
require("Scrollbar")
local json = require("json")

-- TODO [EventGenerator]
-- local event_generator = require("EventGenerator")

local PREV_BUTTON = "Messages_Layer.Navigation_Group.Prev_Img"
local NEXT_BUTTON = "Messages_Layer.Navigation_Group.Next_Img"
local MSG_LAYER = "MSG_Screen.Message_Layer"
local TITLE_CONTROL = "Message_Layer.Title_Text"
local BODY_CONTROL = "Message_Layer.Body_Text"
local IMAGE_CONTROL = "Message_Layer.Image_Img"
local SCROLLBAR = "Messages_Layer.Scrollbar"

local gScrollbar = LayerScrollbar.new{layer=MSG_LAYER,scrollbar=SCROLLBAR}
local gMessageIds = nil
local gMessageIndex = nil
local gMessageDir = nil
local gMessageCache = nil

--
-- message layer scrolling, synchronize scrollbar
--
function CBMSG_SyncScrollbar(mapargs)
  gScrollbar:scroll()
end

--
-- display message on the screen
--
local function show_message(title, image, body)
  local width = gre.get_layer_attrs(MSG_LAYER, "width").width
  local title_ypos = gre.get_value(TITLE_CONTROL..".grd_y")
  local title_dimensions = gre.rtext_text_extent(title, TITLE_CONTROL)
  local body_dimensions = gre.rtext_text_extent(body, BODY_CONTROL)
  local image_width, image_height = 0, 0
  local image_present = image ~= nil
  if image_present then image_width, image_height = png_dimensions(image) end
  image_present = image_present and image_width ~= nil and image_height ~= nil

  local scaled_image_width, scaled_image_height = 0, 0
  if image_present then
    if image_width > width then
      -- must rescale so that width fits
      scaled_image_width = width
      scaled_image_height = (width / image_width) * image_height
    else
      -- do not rescale
      scaled_image_width = image_width
      scaled_image_height = image_height
    end
  end

  local title_height = title_dimensions.height
  local image_xpos = (width - scaled_image_width) / 2
  local image_ypos = title_height + 10
  local body_ypos = image_ypos + scaled_image_height + 10
  local body_height = body_dimensions.height
  local total_height = body_ypos + body_height

  local data = {}
  data[TITLE_CONTROL..".text"] = title
  data[TITLE_CONTROL..".grd_height"] = title_height
  data[TITLE_CONTROL..".grd_hidden"] = false
  data[IMAGE_CONTROL..".grd_hidden"] = not image_present
  data[IMAGE_CONTROL..".image"] = image_present and image or ""
  data[IMAGE_CONTROL..".grd_height"] = scaled_image_height
  data[IMAGE_CONTROL..".grd_width"] = scaled_image_width
  data[IMAGE_CONTROL..".grd_x"] = image_xpos
  data[IMAGE_CONTROL..".grd_y"] = image_ypos
  data[BODY_CONTROL..".text"] = body
  data[BODY_CONTROL..".grd_height"] = body_height
  data[BODY_CONTROL..".grd_y"] = body_ypos
  data[BODY_CONTROL..".grd_hidden"] = false
  gre.set_data(data)
  gre.set_layer_attrs("Message_Layer", { yoffset = 0 })
  gScrollbar:init(total_height)
end

--
-- extract title, image and body context from message json file
--
local function parse_message_json(message_id)
  local json_file = string.format("%s\\%d.msg", gMessageDir, message_id)
  local image_file = string.format("%s\\%d.png", gMessageDir, message_id)
  local npos_start, npos_stop = string.find(json_file, ".*[/\\]")
  local json_file_dir = npos_start ~= nil and string.sub(json_file, npos_start, npos_stop) or ""

  local f = assert(io.open(json_file, "r"))
  local t = f:read("*all")
  f:close()

  local json_content = json.decode(t)

  local title = json_content.title or ""
  local image = file_exists(image_file) and image_file or nil
  local body = json_content.text or ""

  return title, image, body
end

--
-- open a message
--
local function open_message()
  local data = {}
  data[PREV_BUTTON..".grd_hidden"] = gMessageIndex >= #gMessageIds
  data[NEXT_BUTTON..".grd_hidden"] = gMessageIndex <= 1
  gre.set_data(data)

  if gMessageCache[gMessageIndex] == nil then
    local title, image, body = parse_message_json(gMessageIds[gMessageIndex])
    gMessageCache[gMessageIndex] = { title = title, image = image, body = body }
  end

  local msg = gMessageCache[gMessageIndex]
  show_message(msg.title, msg.image, msg.body)

  Event:mark_message_read(gMessageIds[gMessageIndex])
end

--
-- show older message (next in list)
--
function CBMSG_OnPrevMessage(mapargs)
  if gMessageIndex >= #gMessageIds then return end

  gMessageIndex = gMessageIndex + 1
  open_message()
end

--
-- show newer message (previous in list)
--
function CBMSG_OnNextMessage(mapargs)
  if gMessageIndex <= 1 then return end

  gMessageIndex = gMessageIndex - 1
  open_message()
end

--
-- prepare messages screen for display
--
function CBMSG_OnScreenShow(mapargs)
  local data = {}
  data[PREV_BUTTON..".grd_hidden"] = true
  data[NEXT_BUTTON..".grd_hidden"] = true
  data[TITLE_CONTROL..".grd_hidden"] = true
  data[IMAGE_CONTROL..".grd_hidden"] = true
  data[BODY_CONTROL..".grd_hidden"] = true
  data[SCROLLBAR..".grd_hidden"] = true
  gre.set_data(data)

  Control_SetButtons(true, true, true, true, true, true, false)

  gMessageCache = {}
  gMessageIds = nil
  Event:get_messages()

  -- TODO [EventGenerator]
  -- event_generator.get_messages()
end

--
-- io_msglist_reply 1u%d ids 1s0 dir
--
function CBMSG_OnGetMessagesReply(mapargs)
  gMessageIds = convert_to_table(mapargs.context_event_data.ids)
  gMessageIndex = 1
  gMessageDir = mapargs.context_event_data.dir

  if gMessageIds ~= nil and #gMessageIds > 0 then
    open_message()
  end
end
