require("events")
require("ActiveRecipe")
require("ActiveCleanProg")
require("History")


--
-- disable all menu functionality except the standby button
--
local function disable_menu()
  Control_SetButtons(true, false, false, false, false, false, false)
end

--
-- continue button pressed
--
function CBPause_OnResume()
  ActiveRecipe:manually_paused_reset()
  ActiveCleanProg:manually_paused_reset()
  
  Event:action("CONTINUE_ACTION")
  
  gre.set_value("toScreen", History:peak())
  gre.send_event("switch_screen")
end

--
-- recipe canceled
--
function CBPause_OnRecipeCanceled()
  gre.set_value("toScreen", History:peak())
  gre.send_event("switch_screen")
end

--
-- cleaning program canceled
--
function CBPause_OnCleanCanceled(mapargs)
  if mapargs.context_event_data.canceled == 1 then
    gre.set_value("toScreen", History:peak())
    gre.send_event("switch_screen")
  end
end

--
-- check the reason this screen is shown and disable menu buttons
--
function CBPause_OnScreenShow()
  disable_menu()
end

--
-- door closed event, if recipe or cleaning was active go to pause
-- screen, if not go to home screen
-- if pausing was not done manually, resume automatically
--
function CBDoorOpen_OnDoorClosed()
  local bCooking = ActiveRecipe:is_cooking()
  local bCleaning = ActiveCleanProg:is_cleaning() or ActiveCleanProg:is_scheduled()
  
  local to_screen = History:peak()
  
  if bCooking or bCleaning then
    if ActiveRecipe:is_loading() or ActiveRecipe:is_manually_paused() or ActiveCleanProg:is_manually_paused() then
      to_screen = "PAUSE_Screen"
    end
  end
  
  gre.set_value("toScreen", to_screen)
  gre.send_event("switch_screen")
end

--
-- press the rotor button to start it
--
function CBDoorOpen_OnRotorStart()
  Event:start_rotor()
end

--
-- release the rotor button to stop it
--
function CBDoorOpen_OnRotorStop()
  Event:stop_rotor()
end

--
-- recipe canceled
--
function CBDoorOpen_OnRecipeCanceled()
end

--
-- disable menu buttons
-- make sure the rotor buttion is visible 
--
function CBDoorOpen_OnScreenShow()
  disable_menu()
  gre.set_value("DoorOpen_Layer.rotate_img.grd_hidden", false)
end

--
-- goto pause screen
--
function CB_OnPause()
  gre.set_value("toScreen", "PAUSE_Screen")
  gre.send_event("switch_screen")
end

--
-- handle io_resume 
-- 
--
function CB_OnResume()
 local bCooking = ActiveRecipe:is_cooking()
 local bCleaning = ActiveCleanProg:is_cleaning()
 
 -- dispatch
 if bCooking then
   ActiveRecipe:on_continue()
 elseif bCleaning then
   ActiveCleanProg:on_continue() 
 end
 
end



