------------------------------------------------
-- Drag&drop sort of recipes in the REC_Screen
------------------------------------------------

local gRecipeIsPressed = false
local gPressedRecipe = nil

--[[ Drag & drop overlay (actively moving a recipe around) ]]--

local RECIPES_TABLE = "REC_Layer.REC_Recipes_Table"

local gActiveInsertLine = -1

--
-- hide the active insert line
--
local function hide_insert_line()
  if gActiveInsertLine ~= -1 then
    local data = {}
    
    if gActiveInsertLine == 0 then
      data["REC_Layer.InsertTop_Img.grd_hidden"] = true
    else
      data[RECIPES_TABLE..".insert_line_alpha."..gActiveInsertLine..".1"] = 0
    end
    gActiveInsertLine = -1
    
    gre.set_data(data)
  end
end

--
-- show the position where the recipe would be moved if released here
--
local function show_insert_line(index)
  local data = {}

  -- hide old insert line
  hide_insert_line()
  
  -- show new insert line
  gActiveInsertLine = index
  data["REC_Layer.InsertTop_Img.grd_hidden"] = gActiveInsertLine ~= 0
  data[RECIPES_TABLE..".insert_line_alpha."..gActiveInsertLine..".1"] = 255
  
  gre.set_data(data)
end

--
-- move recipe around to new position
--
function CBREC_MotionMove(mapargs)
  if gRecipeIsPressed then
    local y = mapargs.context_event_data.y
    local table_info = gre.get_table_attrs(RECIPES_TABLE, "y", "height", "yoffset", "rows")
    local cell_height = gre.get_table_cell_attrs(RECIPES_TABLE, 1, 1, "height").height
    local drop_index = math.floor((y - table_info.y + (cell_height / 2) - table_info.yoffset) / cell_height)
    
    show_insert_line(math.min(table_info.rows, math.max(drop_index, 0)))
  end
end

--
-- confirm new recipe position by releasing
--
function CBREC_ReleaseMove(mapargs) 
  local insert_index = gActiveInsertLine
  hide_insert_line()
  
  if (gPressedRecipe > 0) and (insert_index ~= -1)
    and ((insert_index > gPressedRecipe) or (insert_index < (gPressedRecipe - 1))) then
    local sorted_recipe_names = {}
    
    local table_count = gre.get_table_attrs(RECIPES_TABLE, "rows").rows
    for i=1,table_count do
      table.insert(sorted_recipe_names, gre.get_value(RECIPES_TABLE..".name."..i..".1"))
    end
    
    local new_active_recipe = insert_index
    local recipe_name = gre.get_value(RECIPES_TABLE..".name."..gPressedRecipe..".1")
    table.insert(sorted_recipe_names, insert_index + 1, recipe_name)
    if insert_index > gPressedRecipe then
      table.remove(sorted_recipe_names, gPressedRecipe)
    else
      table.remove(sorted_recipe_names, gPressedRecipe + 1)
      new_active_recipe = new_active_recipe + 1
    end
    Recipes:update_sort_order(sorted_recipe_names)
    
    REC_InitRecipesTable(false)
    CBREC_OnRecipeSelected({context_row = new_active_recipe});
  end
  
  gRecipeIsPressed = false  
  gre.set_control_attrs("REC_Layer.table_overlay", {hidden = true})
end

--[[ Detect motion to start drag&drop ]]--

local gTimerId = nil
local gPressRecipeY = nil

--
-- timer fired means long press detected, so initiate drag&drop
--
local function on_timer()
  gTimerId = nil
  
  if gRecipeIsPressed then
    -- deselect old selected recipe and select new one
    CBREC_DeselectRecipe()
    CBREC_OnRecipeSelected({context_row = gPressedRecipe})
    
    -- activate drag&drop overlay
    gre.set_control_attrs("REC_Layer.table_overlay", {hidden = false})
  end
end

--
-- press detected on recipe table entry, start timer to detect long press
--
function CBREC_PressRecipe(mapargs)
  gPressRecipeY = mapargs.context_event_data.y
  gPressedRecipe = mapargs.context_row
  gRecipeIsPressed = true
  
  if gTimerId ~= nil then gre.timer_clear_interval(gTimerId) end
  gTimerId = gre.timer_set_timeout(on_timer, 800)
end

--
-- motion means scrolling table and not long press, so cancel the timer
--
function CBREC_MotionRecipe(mapargs)
  if gRecipeIsPressed and math.abs(mapargs.context_event_data.y - gPressRecipeY) > 5 then
    if gTimerId ~= nil then
      gre.timer_clear_timeout(gTimerId)
      gTimerId = nil
    end
  end
end

--
-- do not initiate drag&drop if released before long press timout
--
function CBREC_ReleaseRecipe(mapargs)
  gRecipeIsPressed = false
  
  if gTimerId ~= nil then
    gre.timer_clear_timeout(gTimerId)
    gTimerId = nil
  end
end

--[[ Sorting ]]--

local gSortOrder = 0

--
-- toggle sort order between alphabetic and custom
--
function CBREC_ToggleSortOrder(mapargs)
  gSortOrder = 1 - gSortOrder
  REC_InitRecipesTable(gSortOrder == 1)
end
