------------------------
-- enter filename dialog
------------------------

require("Time")
require("Utf8")

ENTERFILENAME_DIALOG_ACTIVE = false

local FILENAME_FIELD = "EnterFileName_Dialog.filename_text.text"

local gFirstLetter = ""
local gMaxLength = 0
local gDefaultFormat = "%s%02d%02d%02d"
local gDefaultName = ""
local gFileName = ""
local gOnSelect = nil

--
-- key pressed
--
function CBSET_EnterFileName_InputKeyEvent(mapargs)
  if gFileName == nil then gFileName = gFirstLetter end
  
  if mapargs.context_event_data.code == 8 then
    -- backspace, remove last char
    if Utf8_StrLen(gFileName) > 1 then
      gFileName = Utf8_RemoveLastCharacter(gFileName)
    end
  else
    -- append char
    local tmp = gFileName..Utf8_FromUcs2(mapargs.context_event_data.code)
    if Utf8_StrLen(tmp) <= gMaxLength then
      gFileName = tmp
    end
  end
  
  gre.set_value(FILENAME_FIELD, gFileName.."|")
end

--
-- confirm button on keyboard pressed
--
function CBSET_EnterFileName_OnKeyboardConfirm(mapargs)
  gre.set_layer_attrs("EnterFileName_Dialog", { hidden = true })
  
  ENTERFILENAME_DIALOG_ACTIVE = false
  
  if gOnSelect then gOnSelect(gFileName or gDefaultName) end
end

--
-- cancel button on keyboard pressed
--
function CBSET_EnterFileName_OnKeyboardCancel(mapargs)
  gre.set_layer_attrs("EnterFileName_Dialog", { hidden = true })
  
  ENTERFILENAME_DIALOG_ACTIVE = false
end

--
-- prepare enter file name dialog to be shown
--
function CBSET_EnterFileName_OnShowOverlay(first_letter, max_length, on_select_callback)
  ENTERFILENAME_DIALOG_ACTIVE = true
  
  gFirstLetter = first_letter
  gMaxLength = max_length
  gOnSelect = on_select_callback

  local y, m, d, _, _, _ = local_time()
  gDefaultName = string.format(gDefaultFormat, gFirstLetter, y % 100, m, d)
  gFileName = nil
  
  gre.set_value(FILENAME_FIELD, gDefaultName)
  gre.set_layer_attrs("EnterFileName_Dialog", { hidden = false })
  gre.set_layer_attrs("Keyboard_Layer_v2", { hidden = false })
end
