-----------------------
-- select a file dialog
-----------------------

require("Scrollbar")

local FILE_TABLE = "SelectFile_Dialog.file_table"
local SCROLLBAR = "SelectFile_Dialog.Scrollbar"

local gScrollbar = Scrollbar.new{table=FILE_TABLE,scrollbar=SCROLLBAR} 
local gFileName = ""
local gOnSelect = nil

--
-- table scrolling detected, synchronize scrollbar
--
function CBSET_SelectFile_OnSyncScrollbar(mapargs)
  gScrollbar:scroll()
end

--
-- file selected
--
function CBSET_SelectFile_OnSelect(mapargs)
  gFileName = gre.get_value("SelectFile_Dialog.file_table.text."..mapargs.context_row..".1")
  
  gre.set_layer_attrs("SelectFile_Dialog", { hidden = true })
  
  if gOnSelect then gOnSelect(gFileName) end
end

--
-- prepare file selection dialog to be shown
--
function CBSET_SelectFile_OnShowOverlay(files, on_select_callback)
  gFileName = ""
  gOnSelect = on_select_callback
  
  local data = {}
  for i, file in ipairs(files) do data[FILE_TABLE..".text."..i..".1"] = file end
  gre.set_data(data)
  gre.set_table_attrs(FILE_TABLE, { yoffset = 0, rows = #files })
  
  gScrollbar:init()
  
  gre.set_layer_attrs("SelectFile_Dialog", { hidden = false })
end
