--------------------------------------------------------------------------------------
-- STARTUP SEQUENCE: bootloader screen -> fri-jado logo screen -> customer logo screen
--------------------------------------------------------------------------------------

--[[ FRI-JADO LOGO SCREEN ]]--

local gStartTimerDone = false   -- has the minumum amount of time to show this screen passed?
local gRecipesInitDone = false  -- has the recipes database been initialized?
local gSettingsInitdone = false -- has the settings database been initialized?

--
-- only after all data is initialized and the minimum time has passed can we go to the customer logo screen
--
local function CheckInitDone()
  if gStartTimerDone and gRecipesInitDone and gSettingsInitdone then
    if file_exists(absolute_path(customer_image())) then
      gre.send_event("start_customer_screen")
    else
      gre.send_event("skip_customer_screen")
    end
     Event:inited()
  end
end

--
-- minimum time to display the fri-jado logo has passed
--
local function StartTimer_Expired()
  gStartTimerDone = true
  CheckInitDone()
end

--
-- received the minimum time to display the fri-jado logo
--
--- @param gre#context mapargs
function CBSTART_DelayReceived(mapargs)
  gre.timer_set_timeout(StartTimer_Expired, mapargs.context_event_data.delay)
end

--
-- recipes have been initialized
--
function CBSTART_RecipeInitDone()
  gRecipesInitDone = true
  CheckInitDone()
end

--
-- settings have been initialized
--
function CBSTART_SettingsInitDone()
  gSettingsInitdone = true
  CheckInitDone()
end

--
-- preload common resources (menu, keyboards)
--
local function preload_resources()
  local images = {
    -- menu
    image_path("ikonen-bovenbalk-feb-19-pijl.png"),    -- status bar
    image_path("wifi active 8mm.png"),                 -- status bar
    image_path("no-wifi 8mm.png"),                     -- status bar
    image_path("Wifi 8mm.png"),                        -- status bar
    image_path("ikonen-bovenbalk-feb-19-sleutel.png"), -- status bar
    image_path("ikonen-bovenbalk-feb-19-mail.png"),    -- status bar
    image_path("ikoon-midsize-feb19-puntjes.png"),     -- small menu bar
    image_path("ikoon-midsize-feb19-info.png"),        -- small menu bar
    image_path("ikoon-midsize-feb19-help.png"),        -- small menu bar
    image_path("ikoon-midsize-feb19-clean-grill.png"), -- small menu bar
    image_path("ikoon-midsize-feb19-home.png"),        -- small menu bar
    image_path("ikoon-midsize-feb19-recipes.png"),     -- small menu bar
    image_path("ikoon-midsize-feb19-aan-uit.png"),     -- small menu bar
    image_path("ikoon-groot-feb-19-lock-screen.png"),  -- large menu icon
    image_path("ikoon-groot-feb-19-ikoon-groot-feb-19-camera.png"), -- large menu icon
    image_path("ikoon-groot-feb-19-instellingen.png"), -- large menu icon
    image_path("ikoon-groot-feb-19-mail.png"),         -- large menu icon
    image_path("ikoon-groot-feb-19-log-en-maintenance.png"), -- large menu icon
    image_path("ikoon-groot-feb-19-info.png"),         -- large menu icon
    image_path("ikoon-groot-feb-19-help.png"),         -- large menu icon
    image_path("onderpaneel-x9-y172-of-740.png"),      -- background

    -- dim filter
    image_path("CR-dimfilter.png"),                    -- dim filter overlay

    -- dialog box
    image_path("dialogbox.png"),                       -- background
    image_path("dialog-knop-op.png"),                  -- button (not pressed)
    image_path("dialog-knop-neer.png"),                -- button (pressed)
  }

  local fonts = {
    { path = font_path("NotoSansSC_Subset.ttf"), size = 12 }, -- font used in menu
    { path = font_path("NotoSansSC_Subset.ttf"), size = 30 }, -- font used on keyboard keys
    { path = font_path("NotoSansSC_Subset.ttf"), size = 24 }, -- dialog box font
  }

  for _, image in ipairs(images) do
    gre.load_resource("image", image, { background = true })
  end

  for _, font in ipairs(fonts) do
    gre.load_resource("font", font.path, { size = font.size, background = true })
  end
end

--
-- send the events to requests parameters and recipes and clean programs totaltime
--
--- @param gre#context mapargs
function CBSTART_Prepare(mapargs)
  Event:startup_delay()
  Event:get_parameters()
  Event:get_recipes()
  Event:get_cleantotaltimes()

  preload_resources()
end

--[[ CUSTOMER LOGO SCREEN ]]--

--
-- set the customer logo image
--
--- @param gre#context mapargs
function CBCUST_Prepare(mapargs)
  gre.set_value("CR_Customer_Layer.Start_Customer_Img.customer_image", customer_image())
end
