------------------------
-- set local time dialog
------------------------

require("events")
require("Settings")
require("Time")
require("Login_Layer")
require("RoleManager")

local SETTIME_LAYER = "SetTime_Layer"

local gbAmPm = false
local gbIsPm = false
local gSlidingY = 0
local gSlidingHours = false
local gSlidingMinutes = false

--
-- press event on hours or minutes
-- make the respective control active for time scrolling
--
function CBSetTime_Press(mapargs)
  gSlidingY = tonumber(mapargs.context_event_data.y)
  gSlidingHours = false
  gSlidingMinutes = false

  local hours = tonumber(gre.get_value(SETTIME_LAYER..".time_text.hours"))
  local minutes = tonumber(gre.get_value(SETTIME_LAYER..".time_text.minutes"))

  local data = {}

  data[SETTIME_LAYER..".time_text.hours_less"] = ""
  data[SETTIME_LAYER..".time_text.hours_more"] = ""
  data[SETTIME_LAYER..".time_text.minutes_less"] = ""
  data[SETTIME_LAYER..".time_text.minutes_more"] = ""

  if mapargs.context_control == SETTIME_LAYER..".slide_control_hours" then
    gSlidingHours = true
    local min_hours = gbAmPm and 1 or 0
    local max_hours = gbAmPm and 12 or 23
    data[SETTIME_LAYER..".time_text.hours_less"] = string.format("%02d", hours > min_hours and hours - 1 or max_hours)
    data[SETTIME_LAYER..".time_text.hours_more"] = string.format("%02d", hours < max_hours and hours + 1 or min_hours)
  elseif mapargs.context_control == SETTIME_LAYER..".slide_control_minutes" then
    gSlidingMinutes = true
    local max_minutes = 59
    data[SETTIME_LAYER..".time_text.minutes_less"] = string.format("%02d", minutes >= 1 and minutes - 1 or max_minutes)
    data[SETTIME_LAYER..".time_text.minutes_more"] = string.format("%02d", minutes < max_minutes and minutes + 1 or 0)
  end

  gre.set_data(data)
end

--
-- release event on hours or minutes
-- depending on the y-coordinate compared to the y-coordinate from the press event, scroll up or down
--
function CBSetTime_Release(mapargs)
  local y = tonumber(mapargs.context_event_data.y)
  local hours = tonumber(gre.get_value(SETTIME_LAYER..".time_text.hours"))
  local minutes = tonumber(gre.get_value(SETTIME_LAYER..".time_text.minutes"))

  local data = {}

  data[SETTIME_LAYER..".time_text.hours_less"] = ""
  data[SETTIME_LAYER..".time_text.hours_more"] = ""
  data[SETTIME_LAYER..".time_text.minutes_less"] = ""
  data[SETTIME_LAYER..".time_text.minutes_more"] = ""

  if mapargs.context_control == SETTIME_LAYER..".slide_control_hours" and gSlidingHours then
    local old_hours = hours

    local bScrollingDown = y >= (gSlidingY + 5)
    local bScrollingUp = y <= (gSlidingY - 5)
    if bScrollingDown then
      hours = hours - 1
    elseif bScrollingUp then
      hours = hours + 1
    end

    local min_hours = gbAmPm and 1 or 0
    local max_hours = gbAmPm and 12 or 23
    if hours < min_hours then
      hours = max_hours
    end
    if hours > max_hours then
      hours = min_hours
    end

    if gbAmPm then
      if gbIsPm and old_hours == 11 and hours == 12 then gbIsPm = false         -- 11pm -> 12 => am
      elseif gbIsPm and old_hours == 12 and hours == 11 then gbIsPm = false     -- 12pm -> 11 => am
      elseif not gbIsPm and old_hours == 11 and hours == 12 then gbIsPm = true  -- 11am -> 12 => pm
      elseif not gbIsPm and old_hours == 12 and hours == 11 then gbIsPm = true  -- 12am -> 11 => pm
      end
    end

    data[SETTIME_LAYER..".time_text.hours"] = string.format("%02d", hours)
    data[SETTIME_LAYER..".time_text.hours_less"] = string.format("%02d", hours > min_hours and hours - 1 or max_hours)
    data[SETTIME_LAYER..".time_text.hours_more"] = string.format("%02d", hours < max_hours and hours + 1 or min_hours)
    data[SETTIME_LAYER..".ampm_text.text"] = gbAmPm and i18n:get(gbIsPm and "NLS_PM" or "NLS_AM") or ""
  elseif mapargs.context_control == SETTIME_LAYER..".slide_control_minutes" and gSlidingMinutes then
    if y >= (gSlidingY + 5) then
      minutes = minutes - 1
    elseif y <= (gSlidingY - 5) then
      minutes = minutes + 1
    end

    local max_minutes = 59
    if minutes < 0 then minutes = max_minutes end
    if minutes > max_minutes then minutes = 0 end

    data[SETTIME_LAYER..".time_text.minutes"] = string.format("%02d", minutes)
    data[SETTIME_LAYER..".time_text.minutes_less"] = string.format("%02d", minutes >= 1 and minutes - 1 or max_minutes)
    data[SETTIME_LAYER..".time_text.minutes_more"] = string.format("%02d", minutes < max_minutes and minutes + 1 or 0)
  end

  gre.set_data(data)
end

--
-- set the system clock to the updated time
--
function CBSetTime_OnOkPressed(mapargs)
  local new_hours = tonumber(gre.get_value(SETTIME_LAYER..".time_text.hours"))
  local new_minutes = tonumber(gre.get_value(SETTIME_LAYER..".time_text.minutes"))

  local _, _, _, h, min = utc_time(now())
  local offset = Settings:get("TIMEZONE_OFFSET") or 0

  if gbAmPm then
    if not gbIsPm and new_hours == 12 then new_hours = 0 end
    if gbIsPm and new_hours < 12 then new_hours = new_hours + 12 end
  end

  local base_epoch_time = now() - (h * 3600) - (min * 60)
  local new_epoch_time = base_epoch_time + ((new_hours - offset) * 3600) + (new_minutes * 60)

  Event:live_set("SYS_TIME", new_epoch_time)
  Event:live_get("SYS_TIME")
end

--
-- request editing clock time
--
function CBSetTime_OnOverlayShow(mapargs)
  -- check if the manager role is active, since this allows to edit the clock time
  if not RoleManager:can_access(MANAGER_ROLE) then
    LoginDialog_Init(mapargs.context_screen, MANAGER_ROLE)
  else
    CBSetTime_DoOverlayShow(mapargs)
  end
end

--
-- display the set time dialog
--
function CBSetTime_DoOverlayShow(mapargs)
  gSlidingY = 0
  gSlidingHours = false
  gSlidingMinutes = false
  gbAmPm = Settings:get_def("TIME_FORMAT", 0) == 1
  gbIsPm = false

  local _, _, _, h, min, _ = local_time()
  local ampm = ""

  if gbAmPm then
    ampm = i18n:get("NLS_AM")
    if h == 0 then
      h = 12
      ampm = i18n:get("NLS_AM")
    elseif h == 12 then
      ampm = i18n:get("NLS_PM")
      gbIsPm = true
    elseif h > 12 then
      h = h - 12
      ampm = i18n:get("NLS_PM")
      gbIsPm = true
    end
  end

  local data = {}
  data[SETTIME_LAYER..".time_text.hours_less"] = ""
  data[SETTIME_LAYER..".time_text.hours"] = string.format("%02d", h)
  data[SETTIME_LAYER..".time_text.hours_more"] = ""
  data[SETTIME_LAYER..".time_text.minutes_less"] = ""
  data[SETTIME_LAYER..".time_text.minutes"] = string.format("%02d", min)
  data[SETTIME_LAYER..".time_text.minutes_more"] = ""
  data[SETTIME_LAYER..".ampm_text.grd_hidden"] = not gbAmPm
  data[SETTIME_LAYER..".ampm_text.text"] = ampm
  gre.set_data(data)

  gre.set_layer_attrs(SETTIME_LAYER, { hidden = false })
end
