-------------------------------------------------------
-- global callbacks that don't belong elsewhere go here
-------------------------------------------------------

require("Config")
require("Dialog")
require("language")

-- TODO [EventGenerator]
local event_generator = require("EventGenerator")

-- dir list handlers
local gDirListActions = {}

--
-- initialize directory listing actions
--
local function init_dirlistactions()
  gDirListActions[icons_dir()       ] = CBCR_InitIcons
  gDirListActions[settings_dir_usb()] = CBSET_OnSettingsListDirUsb
  gDirListActions[recipes_dir_usb() ] = CBSET_OnRecipesListDirUsb
end

--
-- directory listing reply event received
--
--- @param gre#context mapargs
function CB_OnDirList(mapargs)
  local reply = split_string(mapargs.context_event_data.files, DELIMITER_TOKEN)
  
  local dir = reply[1]
  local files = {}
  
  for i=2,#reply do
    table.insert(files, reply[i])
  end
  
  local action = assert(gDirListActions[dir], "Invalid directory ["..dir.."]")
  action(files)
end

--
-- handle incoming wifi connection
--
--- @param gre#context mapargs
function CB_OnWifiRequest(mapargs)
  local device = mapargs.context_event_data.device
  local dlg = DialogBox.new(DIALOG_TYPE_CONFIRMATION)
  dlg:set_message(string.format(i18n:get("NLS_WIFI_CONNECTION"), device))
  dlg:add_button(i18n:get("NLS_REJECT"), function() Event:wifi_reply(device, false) end)
  dlg:add_button(i18n:get("NLS_ACCEPT"), function() Event:wifi_reply(device, true) end)
  dlg:show()
end

--
-- handle critical error
--
--- @param gre#context mapargs
function CB_OnCriticalError(mapargs)
  local module = mapargs.context_event_data.moduleid
  local line = mapargs.context_event_data.linenumber
  local info = mapargs.context_event_data.extrainfo
  
  print(string.format("Critical Error: Module: %u, Line: %u, Info: %u", module, line, info))
  
  gre.set_layer_attrs_global("CriticalStop_Layer", {hidden = false})
end

--
-- application startup event received
--
--- @param gre#context mapargs
function CB_Init(mapargs)
  init_dirlistactions()
  i18n:init()
  Event:ready()
  Event:live_get("CLEANING_SUPPORTED")
  Event:live_get("SYS_TIME")
  Event:parameter_options("DEVICE_TYPE")
  
  -- TODO [EventGenerator]
  -- event_generator.start()
  
  Event:list_dir(icons_dir())
  CBCR_StepName_OnInit()
end

--
-- application quit event received
--
function CB_Quit()
  -- TODO [EventGenerator]
  -- event_generator.stop() 
end
